(function() {
  //    FILE:ProjectDetailView
  //    PROJECT:fw-mobile
  //    Created by Rafa Dorado on 11/18/13
  //    Farmerswife SL.
  define(['jquery', 'underscore', 'Handlebars', 'Backbone', 'moment', 'models/contact/ContactModel', 'models/time/TimeModel', 'models/event/EventModel', 'collections/event/EventCollection', 'models/bookingstructures/BookingstructuresModel', 'views/contact/CompanyView', 'views/contact/ContactView', 'views/event/EventView', 'views/project/FormProjectView', 'PrecompiledTemplates'], function($, _, Handlebars, Backbone, Moment, ContactModel, TimeModel, EventModel, EventCollection, BookingstructuresModel, CompanyView, ContactView, EventView, FormProjectView) {
    var ProjectDetailView;
    return ProjectDetailView = class ProjectDetailView extends Backbone.View {
      initialize(usr, project, projectCol) {
        this.usr = usr;
        this.project = project;
        this.projectCol = projectCol;
        this.project.on('project_updated', this.update_project_details, this);
        this.project.on('project_updated', this.update_project_customfields, this);
        this.project.on('project_events_updated', this.update_project_events, this);
        return this.time = new TimeModel();
      }

      attributes() {
        return {
          'data-role': 'page',
          'data-name': 'ProjectDetailView'
        };
      }

      events() {
        return {
          'tap #id-btn-back': 'btnBackClicked',
          'tap .btn-submenu-project': 'subMenuProjectClicked',
          'tap #id-btn-project-company': 'btnCompanyClicked',
          'tap #id-btn-project-contact': 'btnContactClicked',
          'tap #id-ul-project-events > li': 'btnEventClicked',
          'tap #id-ul-project-customfields > li': 'btnCustomFieldContactClicked',
          'tap #id-btn-edit-project': 'btnEditProjectClicked'
        };
      }

      render() {
        var template;
        template = Handlebars.templates['ProjectDetailView'];
        this.$el.html(template({
          user: this.usr.toJSON()
        }));
        this.$el.attr('id', 'id-ProjectDetailView');
        this.addSidePanel();
        return this.$el;
      }

      addSidePanel() {
        var MenuView;
        if (window.media_query_min_width(768)) {
          if (!MenuView) {
            MenuView = require("views/menu/MenuView");
          }
          this.panel = new MenuView(this.usr, this.obj);
          this.panel.render();
          return this.$el.append(this.panel.el);
        }
      }

      subMenuProjectClicked(event) {
        var btn, id;
        event.preventDefault();
        event.stopPropagation();
        btn = $(event.currentTarget);
        id = btn.attr('data-target');
        if (id === '#id-divProjectEvents') {
          this.project.get_project_events(this.usr, this.project.get('id'));
        }
        this.$el.find('.subProjectView').hide();
        return this.$el.find(id).show();
      }

      btnBackClicked(event) {
        event.preventDefault();
        event.stopPropagation();
        return $.mobile.jqmNavigator.popView({
          transition: "none"
        });
      }

      //DETAILS TAB
      update_project_details() {
        var htmlHeader, htmlNote, note;
        if (this.project.get('allowEdit')) {
          this.$el.find('#id-btn-edit-project').show();
        } else {
          this.$el.find('#id-btn-edit-project').hide();
        }
        htmlHeader = `<span class='header' id='id-span-name-project'> ${this.project.get('name')} </span> <span class='subheader'> <span class='fwi-project icon-project'/> <span class='number-project' id='id-span-number-project'>${this.project.get('number')}</span> </span> <span id='id-btn-project-company' class='btn-project btn-project1' data-companyID='${this.project.get('contactCompanyID')}'> <span class='fwi-agency icon-left'/> <span class='text-span'>${this.project.get('contactCompanyName')}</span> <span class='fwi-arrow-right arrow-right'/> </span> <span id='id-btn-project-contact' class='btn-project btn-project2' data-contactID='${this.project.get('contactID')}'> <span class='fwi-contact icon-left'/> <span class='text-span'>${this.project.get('contactName')}</span> <span class='fwi-arrow-right arrow-right'/> </span>`;
        this.$el.find('#id-div-project-details-header').html(htmlHeader);
        if (this.project.get('note')) {
          note = this.project.get('note').replace(/(\r\n|\n|\r)/gm, "<br>");
          htmlNote = `<p>Note:</p><span class='note-project'>${note}</span>`;
          this.$el.find('#id-div-project-note').html(htmlNote);
          this.$el.find('#id-div-project-note').show();
        } else {
          this.$el.find('#id-div-project-note').hide();
        }
        return this.$el.find('#id-h1-navbar-title').html(this.project.get('name'));
      }

      btnCompanyClicked(event) {
        var company, companyID, view;
        event.preventDefault();
        event.stopPropagation();
        if (!CompanyView) {
          CompanyView = require("views/contact/CompanyView");
        }
        companyID = $(event.currentTarget).attr('data-companyID');
        company = new ContactModel();
        company.get_details_company(this.usr.get('sessionID'), companyID);
        view = new CompanyView(this.usr, company);
        return $.mobile.jqmNavigator.pushView(view, {
          transition: "none"
        });
      }

      btnContactClicked(event) {
        var contact, contactID, obj, view;
        event.stopPropagation();
        event.preventDefault();
        if (!ContactView) {
          ContactView = require("views/contact/ContactView");
        }
        obj = $(event.currentTarget);
        contactID = obj.attr('data-contactID');
        contact = new ContactModel();
        contact.get_details_contact(this.usr.get('sessionID'), contactID);
        view = new ContactView(this.usr, contact);
        return $.mobile.jqmNavigator.pushView(view, {
          transition: "none"
        });
      }

      //EVENTS TAB
      update_project_events() {
        var days, events, li, that, ul;
        that = this;
        ul = this.$el.find('#id-ul-project-events');
        ul.empty();
        events = this.project.get('events');
        if (_.isArray(events)) {
          days = _.uniq(_.pluck(events, 'day').sort());
        } else if (events) {
          days = [events.day];
          events = [events];
        } else {
          days = [];
        }
        if (days.length > 0) {
          _.each(days.reverse(), function(day) {
            var eventsDay, liDay;
            eventsDay = _.where(events, {
              day: day
            });
            liDay = `<li  class=\"liEventDay \">${Moment(day).format('dddd, MMMM Do YYYY')}</li>`;
            ul.append(liDay);
            return _.each(eventsDay, function(ev) {
              var bookingLineID, eventID, involved, li, mH, sH, spanStatus, timeIn, timeOut, type;
              mH = ev.mainHeader;
              sH = ev.subHeader;
              timeIn = that.time.get_time_string_from_float(parseInt(that.usr.get('dayStartsAt'), 10), parseInt(that.usr.get('usesAMPM'), 10), parseFloat(ev.timeIn));
              timeOut = that.time.get_time_string_from_float(parseInt(that.usr.get('dayStartsAt'), 10), parseInt(that.usr.get('usesAMPM'), 10), parseFloat(ev.timeOut));
              eventID = ev.eventID;
              bookingLineID = ev.bookingLineID;
              type = ev.type;
              li = `<li class=\"liEvent \" data-bookingID=\"${eventID}\" data-bookingLineID=\"${bookingLineID}\" data-dayToShow=\"${day}\">`;
              if (ev.isAlldayEvent) {
                li += "<span class='spanTimeEvent'>All Day</span>";
              } else {
                li += `<span class='spanTimeEvent'>${timeIn}<br/>${timeOut}</span>`;
              }
              li += "<span class='spanSeparator'/>";
              //PROJECT BOOKING
              involved = ev.involvedHeader;
              spanStatus = '<span style="color:red;font-size: 20px;" class="booking-status">&bull;</span>';
              if (ev.isTimereported !== 0) {
                spanStatus = '';
              }
              li += `<span class='header'> ${spanStatus} ${mH} </span>`;
              if (involved) {
                li += `<span class='subheader1'>${involved}</span>`;
              } else {
                li += "<br/>";
              }
              if (sH) {
                li += `<span class='subheader2'>${sH}</span>`;
              } else {
                li += "<br>";
              }
              li += "<span class='fwi-arrow-right arrow-right'/></li>";
              return ul.append(li);
            });
          });
        } else {
          li = '<li class=\"liEvent\">No events for this project</li>';
          ul.append(li);
        }
        ul.listview();
        return ul.listview('refresh');
      }

      btnEditProjectClicked(event) {
        var view;
        event.stopPropagation();
        event.preventDefault();
        if (!FormProjectView) {
          FormProjectView = require('views/project/FormProjectView');
        }
        view = new FormProjectView(this.usr, this.projectCol, this.project);
        return $.mobile.jqmNavigator.pushView(view, {
          transition: "none"
        });
      }

      btnEventClicked(event) {
        var bookingID, bookingLineID, btn, eventMdl;
        event.stopPropagation();
        event.preventDefault();
        btn = $(event.currentTarget);
        bookingID = btn.attr('data-bookingID');
        bookingLineID = btn.attr('data-bookingLineID');
        if (!EventModel) {
          EventModel = require("models/event/EventModel");
        }
        eventMdl = new EventModel({
          bookingID: bookingID,
          bookingLineID: bookingLineID,
          day: btn.attr('data-dayToShow'),
          type: 'project',
          internalType: 'BookingFromProject'
        });
        eventMdl.get_details_event(this.usr.get('sessionID'), 'projectEvent');
        return eventMdl.on('eventFilled', _.bind(this.eventFilled, this, eventMdl));
      }

      eventFilled(eventMdl) {
        var bookingStructures, dayToShow, eventsCol, view;
        if (!EventCollection) {
          EventCollection = require("collections/event/EventCollection");
        }
        if (!EventView) {
          EventView = require("views/event/EventView"); //MAKING SURE IS LOADED
        }
        if (!BookingstructuresModel) {
          BookingstructuresModel = require('models/bookingstructures/BookingstructuresModel');
        }
        eventsCol = new EventCollection(eventMdl);
        dayToShow = Moment(eventMdl.get('day'));
        bookingStructures = new BookingstructuresModel();
        view = new EventView(this.usr, bookingStructures, eventsCol, eventMdl, dayToShow, null);
        return $.mobile.jqmNavigator.pushView(view, {
          transition: "none"
        });
      }

      //CUSTOM FIELDS TAB
      update_project_customfields() {
        var cfs, ul;
        cfs = this.project.get('CustomField');
        ul = this.$el.find('#id-ul-project-customfields');
        _.each(cfs, function(cf) {
          var label, li, value;
          label = cf.label;
          value = cf.value;
          if (cf.canLinkToContact) {
            li = `<li data-customfield=\"${value}\" data-linkType='contact'><span class='label'>${label}</span><div class='value'>${value}</div><span class='fwi-arrow-right arrow-right'/> </li>`;
          } else if (cf.canLinkToCompany) {
            li = `<li data-customfield=\"${value}\" data-linkType='company' data-companyID=\"${cf.companyID}\"><span class='label'>${label}</span><div class='value'>${value}</div><span class='fwi-arrow-right arrow-right'/> </li>`;
          } else {
            li = `<li><span class='label'>${label}</span><div class='value'>${value}</div> </li>`;
          }
          return ul.append(li);
        });
        ul.listview();
        return ul.listview('refresh');
      }

      btnCustomFieldContactClicked(event) {
        var btn, company, contact, type, value, view;
        event.stopPropagation();
        event.preventDefault();
        btn = $(event.currentTarget);
        value = btn.attr('data-customfield');
        type = btn.attr('data-linkType');
        if (!value) {

        } else {
          if (type === 'contact') {
            if (!ContactView) {
              ContactView = require("views/contact/ContactView");
            }
            contact = new ContactModel();
            contact.get_details_contact_from_customfield(this.usr.get('sessionID'), value);
            view = new ContactView(this.usr, contact);
          } else if (type === 'company') {
            if (!CompanyView) {
              CompanyView = require("views/contact/CompanyView");
            }
            company = new ContactModel();
            company.get_details_company(this.usr.get('sessionID'), btn.attr('data-companyID'));
            view = new CompanyView(this.usr, company);
          } else {
            return;
          }
          return $.mobile.jqmNavigator.pushView(view, {
            transition: "none"
          });
        }
      }

    };
  });

}).call(this);
